------------------------------------------------------------------------------
-- Animate 3D Parameters / Set Key, Revision 1.0
--
-- tool script
--
-- This script will animate every 3d parameter and set a key on those with animation.
--
-- written by : Sean Konrad (sean@eyeonline.com)
-- written    : Nov. 02, 2005
-- updated : Nov. 02, 2005
------------------------------------------------------------------------------

-- a function that does the action for the xyz coordinates...

function xyz(inputSubgroup) 
	AnimateInput(inputSubgroup.X)
	AnimateInput(inputSubgroup.Y)
	AnimateInput(inputSubgroup.Z)
end

-- Animates the individual axis.
function AnimateInput(axis) 
	-- Check to see if it's connected to something
	op = axis:GetConnectedOutput()
	-- If it is, check to see if it's using a type of spline animation.  If it's not
	-- it's likely connected to a tracker, so we should leave it alone.
	if op ~= nil then
		-- Get the splines ID..
		op_id = op:GetTool():GetID()
		-- We have many spline options for 3D tools..
		if op_id == "BezierSpline"  or op_id == "BSpline" or op_id == "CubicSpline" or op_id == "NURBSpline" or op_id == "NaturalCubicSpline" then
			
			-- Get the value at the current time and set a key frame..
			val = axis[comp.CurrentTime]
			axis[comp.CurrentTime] = val

		end
	else
		-- if it's not animated, add a new bezier spline
		axis:ConnectTo(BezierSpline())
	end
end

-- if the tool has the child group Transform3DOp, then it's a 3D tool
if tool.Transform3DOp then
	-- call the defined function..
	xyz(tool.Transform3DOp.Translate)
	xyz(tool.Transform3DOp.Rotate)
	xyz(tool.Transform3DOp.Pivot)
	
	-- we only want to connect the target if they're using it..
	if tool.Transform3DOp.UseTarget[comp.CurrentTime] == 1 then
		xyz(tool.Transform3DOp.Target)
	end
else
	-- Give an error if it doesn't have the Transform3DOp parameter..
	print("Please run this script on a 3D tool.")
end

